-- Buat Database (jika belum ada)
CREATE DATABASE IF NOT EXISTS sinyalplay_bot;
USE sinyalplay_bot;

-- Tabel Users (Menyimpan pengguna yang terdaftar)
CREATE TABLE IF NOT EXISTS users (
    telegram_id BIGINT PRIMARY KEY,
    username VARCHAR(255) NOT NULL,
    first_name VARCHAR(255),
    otp VARCHAR(6),
    otp_expiry DATETIME,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Tabel Setting (Menyimpan pengaturan bot)
CREATE TABLE IF NOT EXISTS setting (
    id INT PRIMARY KEY AUTO_INCREMENT,
    token VARCHAR(255) NOT NULL,
    group_id BIGINT NOT NULL,
    interval_campaign INT DEFAULT 5, -- Interval pengiriman kampanye dalam menit
    delay_personal_broadcast INT DEFAULT 2, -- Delay antar broadcast personal dalam detik
    delay_group_broadcast INT DEFAULT 10, -- Delay antar broadcast grup dalam detik
    banned_words TEXT DEFAULT '[]', -- Kata terlarang dalam format JSON
    link_whitelist TEXT DEFAULT '[]', -- Link yang diizinkan dalam format JSON
    welcome_message TEXT DEFAULT NULL, -- Pesan welcome
    welcome_media VARCHAR(255) DEFAULT NULL, -- URL media welcome
    welcome_links TEXT DEFAULT '[]' -- Tombol link dalam format JSON
);

-- Tabel Join History (Menyimpan log user yang masuk)
CREATE TABLE IF NOT EXISTS join_history (
    id INT PRIMARY KEY AUTO_INCREMENT,
    telegram_id BIGINT NOT NULL,
    username VARCHAR(255) NOT NULL,
    first_name VARCHAR(255),
    joined_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Tabel Kampanye (Menyimpan daftar kampanye yang akan dikirim)
CREATE TABLE IF NOT EXISTS campaigns (
    id INT PRIMARY KEY AUTO_INCREMENT,
    content_type ENUM('text', 'image', 'video', 'none') DEFAULT 'text',
    content TEXT NOT NULL,
    media_url VARCHAR(255) DEFAULT NULL,
    media_type ENUM('image', 'video', 'none') DEFAULT 'none',
    buttons TEXT DEFAULT '[]', -- Tombol inline dalam format JSON
    schedule_time DATETIME DEFAULT NULL, -- Waktu kampanye dijadwalkan
    status ENUM('pending', 'sent') DEFAULT 'pending'
);

-- Tabel Log (Menyimpan aktivitas bot)
CREATE TABLE IF NOT EXISTS logs (
    id INT PRIMARY KEY AUTO_INCREMENT,
    log_message TEXT NOT NULL,
    log_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Insert Data Awal untuk Setting
INSERT INTO setting (token, group_id, banned_words, link_whitelist)
VALUES ('7644975357:AAHJ4GkJ5hOUY5F68nkDx18vPyx3hOb3cL4', '-1001919635979', '["spam", "bannedword"]', '["example.com"]')
ON DUPLICATE KEY UPDATE token=VALUES(token), group_id=VALUES(group_id);

-- Berikan hak akses pada user MySQL (Jika diperlukan)
-- GRANT ALL PRIVILEGES ON sinyalplay_bot.* TO 'sinyalplay_bot'@'localhost' IDENTIFIED BY '@Makemoney99';
-- FLUSH PRIVILEGES;
